Ext.data.JsonP.sol_common_as_SimpleExporter({"tagname":"class","name":"sol.common.as.SimpleExporter","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.as.functions.Export.js","href":"lib_sol.common.as.functions.Export.html#sol-common-as-SimpleExporter"}],"aliases":{},"alternateClassNames":[],"extends":"sol.common.as.ExporterBase","mixins":[],"requires":[],"uses":[],"members":[{"name":"bom","tagname":"cfg","owner":"sol.common.as.SimpleExporter","id":"cfg-bom","meta":{}},{"name":"dstDirPath","tagname":"cfg","owner":"sol.common.as.SimpleExporter","id":"cfg-dstDirPath","meta":{}},{"name":"extension","tagname":"cfg","owner":"sol.common.as.SimpleExporter","id":"cfg-extension","meta":{}},{"name":"nameTplString","tagname":"cfg","owner":"sol.common.as.SimpleExporter","id":"cfg-nameTplString","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.as.SimpleExporter","id":"cfg-objId","meta":{}},{"name":"payload","tagname":"cfg","owner":"sol.common.as.SimpleExporter","id":"cfg-payload","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common.as.SimpleExporter","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"tplObjId","tagname":"cfg","owner":"sol.common.as.SimpleExporter","id":"cfg-tplObjId","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.common.as.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"tempExtension","tagname":"property","owner":"sol.common.as.ExporterBase","id":"property-tempExtension","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"execute","tagname":"method","owner":"sol.common.as.FunctionBase","id":"method-execute","meta":{}},{"name":"export","tagname":"method","owner":"sol.common.as.ExporterBase","id":"method-export","meta":{"private":true}},{"name":"getPayloadIds","tagname":"method","owner":"sol.common.as.SimpleExporter","id":"method-getPayloadIds","meta":{}},{"name":"getTemplateExtension","tagname":"method","owner":"sol.common.as.ExporterBase","id":"method-getTemplateExtension","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.as.ExporterBase","id":"method-initialize","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.as.SimpleExporter","id":"method-process","meta":{"abstract":true}},{"name":"writeErrorFile","tagname":"method","owner":"sol.common.as.ExporterBase","id":"method-writeErrorFile","meta":{"private":true}}],"code_type":"ext_define","id":"class-sol.common.as.SimpleExporter","short_doc":"Simple XML exporter\n\nExports the values of an object as XML file and optionally the appropriate payload file\n\nSome of...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.as.FunctionBase","sol.common.as.ExporterBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='docClass'>sol.common.as.FunctionBase</a><div class='subclass '><a href='#!/api/sol.common.as.ExporterBase' rel='sol.common.as.ExporterBase' class='docClass'>sol.common.as.ExporterBase</a><div class='subclass '><strong>sol.common.as.SimpleExporter</strong></div></div></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.as.functions.Export.html#sol-common-as-SimpleExporter' target='_blank'>lib_sol.common.as.functions.Export.js</a></div></pre><div class='doc-contents'><p>Simple XML exporter</p>\n\n<p>Exports the values of an object as XML file and optionally the appropriate payload file</p>\n\n<p>Some of the parameters could be pre-defined in a configuration file.\nThis configuration file can be specified by the <code>$config</code> property.</p>\n\n<p>Example:</p>\n\n<pre><code>var exporter = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common.as.SimpleExporter\" rel=\"sol.common.as.SimpleExporter\" class=\"docClass\">sol.common.as.SimpleExporter</a>\", {\n  $config: \"ARCPATH:/Administration/Business Solutions/invoice/Configuration/sol.invoice.ExportConfig\",\n  objId: \"ARCPATH:/Invoice/Invoice in-tray/Sample invoice\"\n});\nexporter.process();\n</code></pre>\n\n<p>Workflow node sample configuration:</p>\n\n<pre><code>{\n  \"$function\": \"sol.common.as.Exporter\",\n  \"$config\": \"ARCPATH:/Administration/Business Solutions/invoice/Configuration/sol.invoice.ExportConfig\"\n}\n</code></pre>\n\n<p>Sample configuration file:</p>\n\n<pre><code>{\n  \"exporterClassName\": \"<a href=\"#!/api/sol.common.as.SimpleExporter\" rel=\"sol.common.as.SimpleExporter\" class=\"docClass\">sol.common.as.SimpleExporter</a>\",\n  \"tplObjId\": \"ARCPATH:/Administration/Business Solutions/invoice/Export Templates/sol.invoice.xml\",\n  \"dstDirPath\": \"c:/invoice/export\",\n  \"payload\": true,\n  \"overwrite\": true\n}\n</code></pre>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-bom' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.SimpleExporter'>sol.common.as.SimpleExporter</span><br/><a href='source/lib_sol.common.as.functions.Export.html#sol-common-as-SimpleExporter-cfg-bom' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.SimpleExporter-cfg-bom' class='name expandable'>bom</a> : Function<span class=\"signature\"></span></div><div class='description'><div class='short'><p>If true the export file will be exported with a byte order mark</p>\n</div><div class='long'><p>If true the export file will be exported with a byte order mark</p>\n</div></div></div><div id='cfg-dstDirPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.SimpleExporter'>sol.common.as.SimpleExporter</span><br/><a href='source/lib_sol.common.as.functions.Export.html#sol-common-as-SimpleExporter-cfg-dstDirPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.SimpleExporter-cfg-dstDirPath' class='name expandable'>dstDirPath</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Destination directory path</p>\n</div><div class='long'><p>Destination directory path</p>\n</div></div></div><div id='cfg-extension' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.SimpleExporter'>sol.common.as.SimpleExporter</span><br/><a href='source/lib_sol.common.as.functions.Export.html#sol-common-as-SimpleExporter-cfg-extension' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.SimpleExporter-cfg-extension' class='name expandable'>extension</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Extension of the metadata file. ...</div><div class='long'><p>Extension of the metadata file. This will be overriden by the extension from the export template and only be used, if the extension of the template can't be determined.</p>\n</div></div></div><div id='cfg-nameTplString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.SimpleExporter'>sol.common.as.SimpleExporter</span><br/><a href='source/lib_sol.common.as.functions.Export.html#sol-common-as-SimpleExporter-cfg-nameTplString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.SimpleExporter-cfg-nameTplString' class='name expandable'>nameTplString</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Template string for the file name of the export files</p>\n</div><div class='long'><p>Template string for the file name of the export files</p>\n</div></div></div><div id='cfg-objId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.SimpleExporter'>sol.common.as.SimpleExporter</span><br/><a href='source/lib_sol.common.as.functions.Export.html#sol-common-as-SimpleExporter-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.SimpleExporter-cfg-objId' class='name expandable'>objId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID</p>\n</div><div class='long'><p>Object ID</p>\n<p>Overrides: <a href=\"#!/api/sol.common.as.FunctionBase-cfg-objId\" rel=\"sol.common.as.FunctionBase-cfg-objId\" class=\"docClass\">sol.common.as.FunctionBase.objId</a></p></div></div></div><div id='cfg-payload' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.SimpleExporter'>sol.common.as.SimpleExporter</span><br/><a href='source/lib_sol.common.as.functions.Export.html#sol-common-as-SimpleExporter-cfg-payload' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.SimpleExporter-cfg-payload' class='name expandable'>payload</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>If true the payload document will be exported as well</p>\n</div><div class='long'><p>If true the payload document will be exported as well</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.SimpleExporter'>sol.common.as.SimpleExporter</span><br/><a href='source/lib_sol.common.as.functions.Export.html#sol-common-as-SimpleExporter-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.SimpleExporter-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;objId&quot;, &quot;tplObjId&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div><div id='cfg-tplObjId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.SimpleExporter'>sol.common.as.SimpleExporter</span><br/><a href='source/lib_sol.common.as.functions.Export.html#sol-common-as-SimpleExporter-cfg-tplObjId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.SimpleExporter-cfg-tplObjId' class='name expandable'>tplObjId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Template object ID</p>\n</div><div class='long'><p>Template object ID</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='defined-in docClass'>sol.common.as.FunctionBase</a><br/><a href='source/lib_sol.common.as.FunctionBase.html#sol-common-as-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div><div id='property-tempExtension' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.as.ExporterBase' rel='sol.common.as.ExporterBase' class='defined-in docClass'>sol.common.as.ExporterBase</a><br/><a href='source/lib_sol.common.as.functions.Export.html#sol-common-as-ExporterBase-property-tempExtension' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.ExporterBase-property-tempExtension' class='name expandable'>tempExtension</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;$$$&quot;</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-execute' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='defined-in docClass'>sol.common.as.FunctionBase</a><br/><a href='source/lib_sol.common.as.FunctionBase.html#sol-common-as-FunctionBase-method-execute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.FunctionBase-method-execute' class='name expandable'>execute</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Execution of the function module ...</div><div class='long'><p>Execution of the function module</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-export' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.as.ExporterBase' rel='sol.common.as.ExporterBase' class='defined-in docClass'>sol.common.as.ExporterBase</a><br/><a href='source/lib_sol.common.as.functions.Export.html#sol-common-as-ExporterBase-method-export' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.ExporterBase-method-export' class='name expandable'>export</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-getPayloadIds' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.SimpleExporter'>sol.common.as.SimpleExporter</span><br/><a href='source/lib_sol.common.as.functions.Export.html#sol-common-as-SimpleExporter-method-getPayloadIds' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.SimpleExporter-method-getPayloadIds' class='name expandable'>getPayloadIds</a>( <span class='pre'></span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Determinate the payload object IDs ...</div><div class='long'><p>Determinate the payload object IDs</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTemplateExtension' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.as.ExporterBase' rel='sol.common.as.ExporterBase' class='defined-in docClass'>sol.common.as.ExporterBase</a><br/><a href='source/lib_sol.common.as.functions.Export.html#sol-common-as-ExporterBase-method-getTemplateExtension' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.ExporterBase-method-getTemplateExtension' class='name expandable'>getTemplateExtension</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.as.ExporterBase' rel='sol.common.as.ExporterBase' class='defined-in docClass'>sol.common.as.ExporterBase</a><br/><a href='source/lib_sol.common.as.functions.Export.html#sol-common-as-ExporterBase-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.ExporterBase-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.as.FunctionBase-method-initialize\" rel=\"sol.common.as.FunctionBase-method-initialize\" class=\"docClass\">sol.common.as.FunctionBase.initialize</a></p></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.SimpleExporter'>sol.common.as.SimpleExporter</span><br/><a href='source/lib_sol.common.as.functions.Export.html#sol-common-as-SimpleExporter-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.SimpleExporter-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"><span class='abstract' >abstract</span></span></div><div class='description'><div class='short'>Implementation of function modules' process. ...</div><div class='long'><p>Implementation of function modules' process.\nThis function must be implemented by the child class and should contain the logic of the function module.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.as.FunctionBase-method-process\" rel=\"sol.common.as.FunctionBase-method-process\" class=\"docClass\">sol.common.as.FunctionBase.process</a></p></div></div></div><div id='method-writeErrorFile' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.as.ExporterBase' rel='sol.common.as.ExporterBase' class='defined-in docClass'>sol.common.as.ExporterBase</a><br/><a href='source/lib_sol.common.as.functions.Export.html#sol-common-as-ExporterBase-method-writeErrorFile' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.ExporterBase-method-writeErrorFile' class='name expandable'>writeErrorFile</a>( <span class='pre'>message</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>message</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div></div></div></div>","meta":{}});